/*
 * Decompiled with CFR 0.152.
 */
package fftv.math;

public class FFT {
    public static int bitcnt(int n) {
        int n2 = 0;
        while (n != 0) {
            n2 += n & 1;
            n >>>= 1;
        }
        return n2;
    }

    public static boolean bitpar(int n) {
        return (FFT.bitcnt(n) & 1) == 1;
    }

    public static int trailingZero(int n) {
        int n2 = 0;
        n ^= 0xFFFFFFFF;
        while ((n & 1) != 0) {
            ++n2;
            n >>>= 1;
        }
        return n2;
    }

    public static void doDFT(int[] nArray, int n) {
        int n2 = 1 << n;
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                if (FFT.bitpar(j & i)) {
                    n3 -= nArray[j];
                    continue;
                }
                n3 += nArray[j];
            }
            nArray2[i] = n3;
        }
        System.arraycopy(nArray2, 0, nArray, 0, nArray2.length);
    }

    public static int gcd(int n, int n2) {
        while (n != 0) {
            int n3 = n2 %= n;
            n2 = n;
            n = n3;
        }
        return n2;
    }

    public static int doFFT(int[] nArray, int n, int n2) {
        int n3 = FFT.basicFFT(nArray, n2);
        return n * (1 << n2 - n3);
    }

    public static int undoFFT(int[] nArray, int n, int n2) {
        int n3 = FFT.basicFFT(nArray, n2);
        return n / (1 << n3);
    }

    public static int basicFFT(int[] nArray, int n) {
        int n2;
        int n3 = 1 << n;
        int n4 = 0;
        int n5 = 0;
        for (n2 = n - 1; n2 >= 0; --n2) {
            int n6 = 1 << n2;
            int n7 = n6 << 1;
            int n8 = n5;
            n4 += n8;
            n5 = n - 1;
            for (int i = 0; i < n3; i += n7) {
                for (int j = 0; j < n6; ++j) {
                    int n9;
                    int n10;
                    int n11 = nArray[i + j] + nArray[i + j + n6];
                    int n12 = nArray[i + j] - nArray[i + j + n6];
                    if (n11 >= 0) {
                        nArray[i + j] = n11 >>> n8;
                        n10 = FFT.trailingZero(nArray[i + j]);
                    } else {
                        nArray[i + j] = -(-n11 >>> n8);
                        n10 = FFT.trailingZero(-nArray[i + j]);
                    }
                    if (n12 >= 0) {
                        nArray[i + j + n6] = n12 >>> n8;
                        n9 = FFT.trailingZero(nArray[i + j + n6]);
                    } else {
                        nArray[i + j + n6] = -(-n12 >>> n8);
                        n9 = FFT.trailingZero(-nArray[i + j + n6]);
                    }
                    int n13 = n10 < n9 ? n10 : n9;
                    n5 = n5 > n13 ? n13 : n5;
                }
            }
        }
        if (n5 > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                if (nArray[n2] > 0) {
                    int n14 = n2;
                    nArray[n14] = nArray[n14] >>> n5;
                    continue;
                }
                nArray[n2] = -(-nArray[n2] >>> n5);
            }
            n4 += n5;
        }
        return n4;
    }

    public static float getEntropy(int[] nArray, int n, int n2) {
        int n3 = 1 << n2;
        float f = n;
        float f2 = (float)Math.log(2.0);
        float f3 = 0.0f;
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] == 0) continue;
            float f4 = (float)nArray[i] / f;
            f4 *= f4;
            f3 = (float)((double)f3 - (double)f4 * (Math.log(f4) / (double)f2));
        }
        return f3;
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 6;
        int n3 = 1 << n2;
        int[] nArray = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = Math.random() > 0.5 ? 1 : -1;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        long l = System.currentTimeMillis();
        int n4 = FFT.doFFT(nArray2, 1, n2);
        FFT.undoFFT(nArray2, n4, n2);
        long l2 = System.currentTimeMillis();
        System.err.println("FFT Time: " + (l2 - l));
        System.out.print("Func: ");
        for (n = 0; n < nArray.length; ++n) {
            System.out.print(nArray[n]);
            System.out.print(" ");
        }
        System.out.println();
        System.err.println("FFT Time: " + (l2 - l));
        System.out.print("FFT : ");
        for (n = 0; n < nArray2.length; ++n) {
            System.out.print(nArray2[n]);
            System.out.print(" ");
        }
    }
}

