/*
 * Decompiled with CFR 0.152.
 */
package fftv.ui;

import fftv.math.FFT;
import fftv.ui.CellClickEvent;
import fftv.ui.CellClickEventListener;
import fftv.ui.FunctionPanel;
import fftv.ui.VectorVis;
import fftv.util.JSBitNum;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import layout.TableLayout;
import layout.TableLayoutConstraints;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

public class FFTWorkshop
extends JFrame
implements VectorVis.SelectionModel {
    private JTextArea customFuncText;
    private JSlider dimSlider;
    private JButton evalFuncButton;
    private JCheckBox fftCheck;
    private JPanel functionEditPanel;
    private FunctionPanel functionPanel1;
    private JPanel functionScriptPanel;
    private JPanel globalPanel;
    private JButton jClearSelection;
    private JLabel jEntropy;
    private JButton jFLipSign;
    private JLabel jFuncDeclareLabel;
    private JButton jInvertSelection;
    private JLabel jLabel7;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JButton jNormalizeButton;
    private JScrollPane jScrollPane4;
    private JButton jSignButton;
    private JSplitPane jSplitPane1;
    private JLabel jThresLabel;
    private JTextField jThreshField;
    private JTextField jValueField;
    private JTextField jWeightField;
    private JLabel jWeightLabel;
    private JLabel jsStatusLabel;
    private JLabel jvalueLabel;
    private JPanel selectValuePanel;
    private JPanel selectionPanel;
    private int dim;
    private int funcScale;
    private int[] curFunc;
    private int fftScale;
    private int[] curFuncFFT;
    private float entropy;
    private boolean[] selection;
    private boolean needFFT;
    private boolean needUnFFT;
    private Context cx = Context.enter();
    private Scriptable scope = this.cx.initStandardObjects(null);

    public FFTWorkshop() {
        FFTWorkshop fFTWorkshop = this;
        fFTWorkshop.cx.exit();
        this.initComponents();
        this.dimChanged(10);
        this.dimSlider.setValue(this.dim);
        this.functionPanel1.setDimension(this.dim);
        this.functionPanel1.setScale(1);
        this.functionPanel1.setDisplayVector(this.curFunc);
        this.clearSelection();
        this.functionPanel1.setSelectionModel(this);
        this.evalFuncButtonActionPerformed(null);
    }

    private void initComponents() {
        this.dimSlider = new JSlider();
        this.jSplitPane1 = new JSplitPane();
        this.functionEditPanel = new JPanel();
        this.functionPanel1 = new FunctionPanel();
        this.globalPanel = new JPanel();
        this.jEntropy = new JLabel();
        this.fftCheck = new JCheckBox();
        this.jSignButton = new JButton();
        this.jNormalizeButton = new JButton();
        this.selectionPanel = new JPanel();
        this.jClearSelection = new JButton();
        this.jInvertSelection = new JButton();
        this.jThresLabel = new JLabel();
        this.jThreshField = new JTextField();
        this.jWeightLabel = new JLabel();
        this.jWeightField = new JTextField();
        this.selectValuePanel = new JPanel();
        this.jFLipSign = new JButton();
        this.jvalueLabel = new JLabel();
        this.jValueField = new JTextField();
        this.functionScriptPanel = new JPanel();
        this.jFuncDeclareLabel = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.customFuncText = new JTextArea();
        this.jLabel7 = new JLabel();
        this.jsStatusLabel = new JLabel();
        this.evalFuncButton = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FFTWorkshop.this.exitForm(windowEvent);
            }
        });
        this.dimSlider.setSnapToTicks(true);
        this.dimSlider.setPaintLabels(true);
        this.dimSlider.setPaintTicks(true);
        this.dimSlider.setMinimum(1);
        this.dimSlider.setMajorTickSpacing(1);
        this.dimSlider.setToolTipText("Number of input bits");
        this.dimSlider.setMaximum(20);
        this.dimSlider.setValue(10);
        this.dimSlider.setName("");
        this.dimSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FFTWorkshop.this.dimSliderStateChanged(changeEvent);
            }
        });
        this.getContentPane().add((Component)this.dimSlider, "South");
        TableLayout tableLayout = new TableLayout();
        tableLayout.setColumn(new double[]{-1.0});
        tableLayout.setRow(new double[]{-1.0, -2.0, -2.0, -2.0});
        this.functionEditPanel.setLayout(tableLayout);
        this.functionPanel1.addCellClickEventListener(new CellClickEventListener(){

            public void cellClicked(CellClickEvent cellClickEvent) {
                FFTWorkshop.this.functionPanel1CellClicked(cellClickEvent);
            }
        });
        this.functionEditPanel.add((Component)this.functionPanel1, new TableLayoutConstraints(0, 0, 0, 0, 2, 2));
        TableLayout tableLayout2 = new TableLayout();
        tableLayout2.setRow(new double[]{-1.0});
        tableLayout2.setColumn(new double[]{-1.0, -2.0, -2.0, -2.0});
        this.globalPanel.setLayout(tableLayout2);
        this.jEntropy.setText("Entropy: 0.00000");
        this.globalPanel.add((Component)this.jEntropy, new TableLayoutConstraints(0, 0, 0, 0, 2, 2));
        this.fftCheck.setText("FFT View");
        this.fftCheck.setToolTipText("Switch between the FFT and Value representations");
        this.fftCheck.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FFTWorkshop.this.fftCheckStateChanged(changeEvent);
            }
        });
        this.globalPanel.add((Component)this.fftCheck, new TableLayoutConstraints(1, 0, 1, 0, 2, 2));
        this.jSignButton.setText("Round to Boolean");
        this.jSignButton.setToolTipText("Round the function to the nearest boolean function");
        this.jSignButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTWorkshop.this.jSignButtonActionPerformed(actionEvent);
            }
        });
        this.globalPanel.add((Component)this.jSignButton, new TableLayoutConstraints(2, 0, 2, 0, 2, 2));
        this.jNormalizeButton.setText("Normalize");
        this.jNormalizeButton.setToolTipText("Renormalize function");
        this.jNormalizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTWorkshop.this.jNormalizeButtonActionPerformed(actionEvent);
            }
        });
        this.globalPanel.add((Component)this.jNormalizeButton, new TableLayoutConstraints(3, 0, 3, 0, 2, 2));
        this.functionEditPanel.add((Component)this.globalPanel, new TableLayoutConstraints(0, 1, 0, 1, 2, 2));
        TableLayout tableLayout3 = new TableLayout();
        tableLayout3.setColumn(new double[]{-2.0, -2.0, -2.0, -1.0, -2.0, -1.0});
        tableLayout3.setRow(new double[]{-2.0});
        this.selectionPanel.setLayout(tableLayout3);
        this.selectionPanel.setBorder(new TitledBorder("Selection"));
        this.jClearSelection.setText("Clear");
        this.jClearSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTWorkshop.this.jClearSelectionActionPerformed(actionEvent);
            }
        });
        this.selectionPanel.add((Component)this.jClearSelection, new TableLayoutConstraints(0, 0, 0, 0, 2, 2));
        this.jInvertSelection.setText("Invert");
        this.jInvertSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTWorkshop.this.jInvertSelectionActionPerformed(actionEvent);
            }
        });
        this.selectionPanel.add((Component)this.jInvertSelection, new TableLayoutConstraints(1, 0, 1, 0, 2, 2));
        this.jThresLabel.setText("By Threshold:");
        this.selectionPanel.add((Component)this.jThresLabel, new TableLayoutConstraints(2, 0, 2, 0, 2, 2));
        this.jThreshField.setText("0.0");
        this.jThreshField.setToolTipText("Select everything whose square is above this threshold");
        this.jThreshField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTWorkshop.this.jThreshFieldActionPerformed(actionEvent);
            }
        });
        this.selectionPanel.add((Component)this.jThreshField, new TableLayoutConstraints(3, 0, 3, 0, 2, 2));
        this.jWeightLabel.setText("By Weight");
        this.selectionPanel.add((Component)this.jWeightLabel, new TableLayoutConstraints(4, 0, 4, 0, 2, 2));
        this.jWeightField.setText("0");
        this.jWeightField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTWorkshop.this.jWeightFieldActionPerformed(actionEvent);
            }
        });
        this.selectionPanel.add((Component)this.jWeightField, new TableLayoutConstraints(5, 0, 5, 0, 2, 2));
        this.functionEditPanel.add((Component)this.selectionPanel, new TableLayoutConstraints(0, 2, 0, 2, 2, 2));
        this.selectValuePanel.setLayout(new GridBagLayout());
        this.selectValuePanel.setBorder(new TitledBorder("Selected Values"));
        this.jFLipSign.setText("Flip Sign");
        this.jFLipSign.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTWorkshop.this.jFLipSignActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.selectValuePanel.add((Component)this.jFLipSign, gridBagConstraints);
        this.jvalueLabel.setText("Set Value:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        this.selectValuePanel.add((Component)this.jvalueLabel, gridBagConstraints);
        this.jValueField.setText("0.0");
        this.jValueField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTWorkshop.this.jValueFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.selectValuePanel.add((Component)this.jValueField, gridBagConstraints);
        this.functionEditPanel.add((Component)this.selectValuePanel, new TableLayoutConstraints(0, 3, 0, 3, 2, 2));
        this.jSplitPane1.setLeftComponent(this.functionEditPanel);
        TableLayout tableLayout4 = new TableLayout();
        tableLayout4.setColumn(new double[]{-1.0});
        tableLayout4.setRow(new double[]{-2.0, -1.0, -2.0, -2.0, -2.0});
        this.functionScriptPanel.setLayout(tableLayout4);
        this.jFuncDeclareLabel.setHorizontalAlignment(2);
        this.jFuncDeclareLabel.setText("function (x,n) {");
        this.functionScriptPanel.add((Component)this.jFuncDeclareLabel, new TableLayoutConstraints(0, 0, 0, 0, 2, 2));
        this.customFuncText.setTabSize(4);
        this.customFuncText.setText("return x.size > n/2");
        this.jScrollPane4.setViewportView(this.customFuncText);
        this.functionScriptPanel.add((Component)this.jScrollPane4, new TableLayoutConstraints(0, 1, 0, 1, 2, 2));
        this.jLabel7.setHorizontalAlignment(2);
        this.jLabel7.setText("}");
        this.functionScriptPanel.add((Component)this.jLabel7, new TableLayoutConstraints(0, 2, 0, 2, 2, 2));
        this.jsStatusLabel.setForeground((Color)UIManager.getDefaults().get("OptionPane.errorDialog.border.background"));
        this.functionScriptPanel.add((Component)this.jsStatusLabel, new TableLayoutConstraints(0, 3, 0, 3, 2, 2));
        this.evalFuncButton.setText("Evaluate");
        this.evalFuncButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FFTWorkshop.this.evalFuncButtonActionPerformed(actionEvent);
            }
        });
        this.functionScriptPanel.add((Component)this.evalFuncButton, new TableLayoutConstraints(0, 4, 0, 4, 2, 2));
        this.jSplitPane1.setRightComponent(this.functionScriptPanel);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.jMenu1.setText("Menu");
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jNormalizeButtonActionPerformed(ActionEvent actionEvent) {
        this.renormalize();
    }

    private void functionPanel1CellClicked(CellClickEvent cellClickEvent) {
        int n = cellClickEvent.getIndex();
        boolean bl = !this.selection[n];
        this.selection[n] = bl;
        this.functionPanel1.selectionChanged();
    }

    private void fftCheckStateChanged(ChangeEvent changeEvent) {
        if (this.fftCheck.isSelected()) {
            if (this.needFFT) {
                this.recalcFFT();
            }
            this.functionPanel1.setScale(this.fftScale);
            this.functionPanel1.setDisplayVector(this.curFuncFFT);
            this.functionPanel1.vectorChanged();
        } else {
            if (this.needUnFFT) {
                this.recalcFunc();
            }
            this.functionPanel1.setScale(this.funcScale);
            this.functionPanel1.setDisplayVector(this.curFunc);
            this.functionPanel1.vectorChanged();
        }
    }

    private void evalFuncButtonActionPerformed(ActionEvent actionEvent) {
        this.cx = Context.enter();
        try {
            String string = "function f(x,n) {\n" + this.customFuncText.getText() + "\n}";
            Function function = this.cx.compileFunction(this.scope, string, "CustomFunction", 1, null);
            this.jsStatusLabel.setText("");
            if (function != null) {
                Object[] objectArray = new Object[2];
                objectArray[1] = new Integer(this.dim);
                for (int i = 0; i < this.curFunc.length; ++i) {
                    objectArray[0] = new JSBitNum(i);
                    Object object = function.call(this.cx, this.scope, this.scope, objectArray);
                    this.curFunc[i] = Context.toBoolean(object) ? -1 : 1;
                }
                this.funcScale = 1;
                this.recalcFFT();
            }
        }
        catch (EcmaError ecmaError) {
            String string = ecmaError.getMessage();
            int n = ecmaError.getLineNumber();
            int n2 = ecmaError.getColumnNumber();
            String string2 = this.customFuncText.getText();
            int n3 = 2;
            int n4 = 1;
            for (int i = 0; i < string2.length() && n3 <= n && n4 <= n2; ++i, ++n4) {
                if (n3 == n && n4 == n2) {
                    this.customFuncText.select(i, i + 1);
                    break;
                }
                if (string2.charAt(i) != '\n') continue;
                ++n3;
                n4 = 0;
            }
            this.jsStatusLabel.setText(string + "(line " + (n - 1) + ", col " + n2 + ")");
        }
        catch (JavaScriptException javaScriptException) {
            // empty catch block
        }
        FFTWorkshop fFTWorkshop = this;
        fFTWorkshop.cx.exit();
    }

    private void jValueFieldActionPerformed(ActionEvent actionEvent) {
        try {
            float f = Float.parseFloat(this.jValueField.getText());
            if (this.fftCheck.isSelected()) {
                this.fftScale = this.setSelectionValue((int)(f * (float)(1 << this.dim)), 1 << this.dim, this.curFuncFFT, this.fftScale, this.selection);
                this.recalcFunc();
            } else {
                this.funcScale = this.setSelectionValue((int)(f * (float)(1 << this.dim)), 1 << this.dim, this.curFunc, this.funcScale, this.selection);
                this.recalcFFT();
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.getToolkit().beep();
        }
    }

    private void jFLipSignActionPerformed(ActionEvent actionEvent) {
        if (this.fftCheck.isSelected()) {
            for (int i = 0; i < this.selection.length; ++i) {
                if (!this.selection[i]) continue;
                this.curFuncFFT[i] = -this.curFuncFFT[i];
            }
            this.recalcFunc();
        } else {
            for (int i = 0; i < this.selection.length; ++i) {
                if (!this.selection[i]) continue;
                this.curFunc[i] = -this.curFunc[i];
            }
            this.recalcFFT();
        }
    }

    private void jWeightFieldActionPerformed(ActionEvent actionEvent) {
        try {
            int n = Integer.parseInt(this.jWeightField.getText());
            for (int i = 0; i < this.selection.length; ++i) {
                if (FFT.bitcnt(i) < n) continue;
                this.selection[i] = !this.selection[i];
            }
            this.functionPanel1.selectionChanged();
        }
        catch (NumberFormatException numberFormatException) {
            this.getToolkit().beep();
        }
    }

    private void jThreshFieldActionPerformed(ActionEvent actionEvent) {
        try {
            float f = Float.parseFloat(this.jThreshField.getText());
            if (this.fftCheck.isSelected()) {
                int n = (int)(f * (float)(this.fftScale * this.fftScale));
                for (int i = 0; i < this.selection.length; ++i) {
                    if (this.curFuncFFT[i] * this.curFuncFFT[i] < n) continue;
                    this.selection[i] = !this.selection[i];
                }
            } else {
                int n = (int)(f * (float)(this.funcScale * this.funcScale));
                for (int i = 0; i < this.selection.length; ++i) {
                    if (this.curFunc[i] * this.curFunc[i] < n) continue;
                    this.selection[i] = !this.selection[i];
                }
            }
            this.functionPanel1.selectionChanged();
        }
        catch (NumberFormatException numberFormatException) {
            this.getToolkit().beep();
        }
    }

    private void jInvertSelectionActionPerformed(ActionEvent actionEvent) {
        this.invertSelection();
    }

    private void jClearSelectionActionPerformed(ActionEvent actionEvent) {
        this.clearSelection();
    }

    private void jSignButtonActionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.curFunc.length; ++i) {
            this.curFunc[i] = this.curFunc[i] >= 0 ? 1 : -1;
        }
        this.funcScale = 1;
        this.recalcFFT();
    }

    private void dimSliderStateChanged(ChangeEvent changeEvent) {
        this.dimChanged(this.dimSlider.getValue());
    }

    private void dimChanged(int n) {
        if (n == this.dim) {
            return;
        }
        this.dim = n;
        this.functionPanel1.setDimension(n);
        this.curFunc = new int[1 << n];
        this.funcScale = 1;
        this.curFuncFFT = new int[1 << n];
        this.fftScale = 1;
        this.selection = new boolean[1 << n];
        this.clearSelection();
        this.functionPanel1.setScale(1);
        this.functionPanel1.setDisplayVector(this.curFunc);
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        new FFTWorkshop().show();
    }

    private void clearSelection() {
        for (int i = 0; i < this.selection.length; ++i) {
            this.selection[i] = false;
        }
        this.functionPanel1.selectionChanged();
    }

    private void invertSelection() {
        for (int i = 0; i < this.selection.length; ++i) {
            this.selection[i] = !this.selection[i];
        }
        this.functionPanel1.selectionChanged();
    }

    private int setSelectionValue(int n, int n2, int[] nArray, int n3, boolean[] blArray) {
        int n4;
        int n5 = 1;
        int n6 = n3;
        if (n2 != n3) {
            n4 = FFT.gcd(n2, n3);
            n = n * n3 / n4;
            n5 = n2 / n4;
            n6 = n2 * n3 / n4;
        }
        for (n4 = 0; n4 < blArray.length; ++n4) {
            int n7 = n4;
            nArray[n7] = nArray[n7] * n5;
            if (!blArray[n4]) continue;
            nArray[n4] = n;
        }
        return n6;
    }

    private void recalcFunc() {
        System.arraycopy(this.curFuncFFT, 0, this.curFunc, 0, this.curFunc.length);
        this.funcScale = FFT.undoFFT(this.curFunc, this.fftScale, this.dim);
        this.entropy = FFT.getEntropy(this.curFuncFFT, this.fftScale, this.dim);
        this.jEntropy.setText("Entropy: " + this.entropy);
        this.needUnFFT = false;
        this.fftCheckStateChanged(null);
    }

    private void recalcFFT() {
        System.arraycopy(this.curFunc, 0, this.curFuncFFT, 0, this.curFunc.length);
        this.fftScale = FFT.doFFT(this.curFuncFFT, this.funcScale, this.dim);
        this.entropy = FFT.getEntropy(this.curFuncFFT, this.fftScale, this.dim);
        this.jEntropy.setText("Entropy: " + this.entropy);
        this.needFFT = false;
        this.fftCheckStateChanged(null);
    }

    private void renormalize() {
        this.fftScale = 0;
        for (int i = 0; i < this.curFuncFFT.length; ++i) {
            this.fftScale += this.curFuncFFT[i] * this.curFuncFFT[i];
        }
        this.fftScale = (int)Math.sqrt(this.fftScale);
        this.recalcFunc();
    }

    public boolean isSelected(int n) {
        return this.selection != null && this.selection[n];
    }
}

