/*
 * Decompiled with CFR 0.152.
 */
package fftv.ui;

import fftv.ui.CellChangedEvent;
import fftv.ui.CellChangedEventListener;
import fftv.ui.CellClickEvent;
import fftv.ui.CellClickEventListener;
import fftv.ui.VectorVis;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;

public class FunctionPanel
extends JPanel {
    private JLabel jStatus;
    private JPanel jInfoPanel;
    private VectorVis jFunction;
    private int lastMouseIndex = -1;

    public FunctionPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jInfoPanel = new JPanel();
        this.jStatus = new JLabel();
        this.jFunction = new VectorVis();
        this.setLayout(new BorderLayout());
        this.jInfoPanel.setLayout(new BorderLayout());
        this.jInfoPanel.setBorder(new SoftBevelBorder(1));
        this.jStatus.setText("jLabel1");
        this.jInfoPanel.add((Component)this.jStatus, "Center");
        this.add((Component)this.jInfoPanel, "South");
        this.jFunction.addCellChangedEventListener(new CellChangedEventListener(){

            public void cellChanged(CellChangedEvent cellChangedEvent) {
                FunctionPanel.this.jFunctionCellChanged(cellChangedEvent);
            }
        });
        this.jFunction.addCellClickEventListener(new CellClickEventListener(){

            public void cellClicked(CellClickEvent cellClickEvent) {
                FunctionPanel.this.jFunctionCellClicked(cellClickEvent);
            }
        });
        this.add((Component)this.jFunction, "Center");
    }

    private void jFunctionCellClicked(CellClickEvent cellClickEvent) {
    }

    private void jFunctionCellChanged(CellChangedEvent cellChangedEvent) {
        CharSequence charSequence;
        int n = cellChangedEvent.getNewIndex();
        String string = Integer.toBinaryString(n);
        int n2 = this.getDimension();
        if (string.length() < n2) {
            charSequence = new StringBuffer(n2);
            for (int i = 0; i < n2 - string.length(); ++i) {
                charSequence.append(0);
            }
            string = charSequence.toString() + string;
        }
        charSequence = string + ": " + this.jFunction.getCellValue(n) + "/" + this.jFunction.getScale();
        this.jStatus.setText((String)charSequence);
    }

    public int getDimension() {
        return this.jFunction.getDimension();
    }

    public void setDimension(int n) {
        this.jFunction.setDimension(n);
    }

    public int getScale() {
        return this.jFunction.getScale();
    }

    public void setScale(int n) {
        this.jFunction.setScale(n);
    }

    public int[] getDisplayVector() {
        return this.jFunction.getDisplayVector();
    }

    public void setSelectionModel(VectorVis.SelectionModel selectionModel) {
        this.jFunction.setSelectionModel(selectionModel);
    }

    public void selectionChanged() {
        this.jFunction.selectionChanged();
    }

    public void setDisplayVector(int[] nArray) {
        this.jFunction.setDisplayVector(nArray);
    }

    public void vectorChanged() {
        this.jFunction.vectorChanged();
    }

    public synchronized void addCellClickEventListener(CellClickEventListener cellClickEventListener) {
        this.jFunction.addCellClickEventListener(cellClickEventListener);
    }

    public synchronized void removeCellClickEventListener(CellClickEventListener cellClickEventListener) {
        this.jFunction.removeCellClickEventListener(cellClickEventListener);
    }

    public synchronized void addCellChangedEventListener(CellChangedEventListener cellChangedEventListener) {
        this.jFunction.addCellChangedEventListener(cellChangedEventListener);
    }

    public synchronized void removeCellChangedEventListener(CellChangedEventListener cellChangedEventListener) {
        this.jFunction.removeCellChangedEventListener(cellChangedEventListener);
    }
}

