/*
 * Decompiled with CFR 0.152.
 */
package fftv.ui;

import fftv.math.FFT;
import fftv.ui.CellChangedEvent;
import fftv.ui.CellChangedEventListener;
import fftv.ui.CellClickEvent;
import fftv.ui.CellClickEventListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.EventListener;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class VectorVis
extends JPanel {
    protected int[] vec;
    protected int scale;
    protected int maxVal;
    protected int xExtent;
    protected int yExtent;
    protected int[] xIndex;
    protected int[] yIndex;
    protected int n;
    private int cellWidth;
    private int cellHeight;
    private int xStep;
    private int yStep;
    private int xInset;
    private int yInset;
    private int lastMouseIndex = -1;
    private SelectionModel selectionModel = null;
    private EventListenerList listenerList = null;

    public VectorVis() {
        this.setDimension(1);
        this.setPreferredSize(new Dimension(500, 500));
        this.addComponentListener(new ResizeListener());
        this.addMouseMotionListener(new MouseMotionListener());
        this.addMouseListener(new MouseClickListener());
    }

    static int fac(int n) {
        int n2 = 1;
        for (int i = 2; i <= n; ++i) {
            n2 *= i;
        }
        return n2;
    }

    static int[] getSortedIndices(int n) {
        int n2;
        int[] nArray = new int[n];
        int n3 = VectorVis.fac(n);
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = n3 / (VectorVis.fac(n - n2) * VectorVis.fac(n2));
        }
        for (n2 = 1; n2 < n; ++n2) {
            int n4 = n2;
            nArray[n4] = nArray[n4] + nArray[n2 - 1];
        }
        int n5 = 1 << n;
        int[] nArray2 = new int[n5];
        n2 = 1;
        while (n2 < n5) {
            int n6 = FFT.bitcnt(n2);
            nArray2[nArray[n6 - 1]] = n2++;
            int n7 = n6 - 1;
            nArray[n7] = nArray[n7] + 1;
        }
        return nArray2;
    }

    private void findMaxVal() {
        int n = 1 << this.n;
        this.maxVal = 0;
        for (int i = 0; i < n; ++i) {
            int n2 = Math.abs(this.vec[i]);
            if (n2 <= this.maxVal) continue;
            this.maxVal = n2;
        }
        if (this.maxVal == 0) {
            this.maxVal = this.scale;
        }
    }

    public void vectorChanged() {
        if (this.vec != null) {
            this.findMaxVal();
            if (this.hasFocus()) {
                this.fireCellChangedEvent(this.lastMouseIndex, this.lastMouseIndex);
            }
        }
        this.repaint();
    }

    public void vectorChanged(int n) {
        if (this.vec != null) {
            int n2;
            int n3 = n2 = this.vec[n] < 0 ? -this.vec[n] : this.vec[n];
            if (n2 > this.maxVal) {
                this.maxVal = n2;
            }
            if (this.hasFocus() && this.lastMouseIndex == n) {
                this.fireCellChangedEvent(this.lastMouseIndex, this.lastMouseIndex);
            }
        }
        this.repaint();
    }

    public void selectionChanged() {
        this.repaint();
    }

    private void calcCellGeom() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n == 0 || n2 == 0 || this.xExtent == 0 || this.yExtent == 0) {
            this.yStep = 1;
            this.xStep = 1;
            this.cellHeight = 1;
            this.cellWidth = 1;
            this.yInset = 0;
            this.xInset = 0;
            return;
        }
        this.cellWidth = n / this.xExtent;
        this.cellHeight = n2 / this.yExtent;
        this.xStep = 1;
        this.yStep = 1;
        this.yInset = 0;
        this.xInset = 0;
        if (this.cellWidth == 0) {
            this.cellWidth = 1;
            this.xStep = this.xExtent / n;
        } else {
            this.xInset = (n - this.cellWidth * this.xExtent) / 2;
        }
        if (this.cellHeight == 0) {
            this.cellHeight = 1;
            this.yStep = this.yExtent / n2;
        } else {
            this.yInset = (n2 - this.cellHeight * this.yExtent) / 2;
        }
    }

    int getCellX(int n) {
        if ((n -= this.xInset) < 0) {
            return 0;
        }
        int n2 = n / this.cellWidth;
        if (n2 >= this.xExtent) {
            n2 = this.xExtent - 1;
        }
        return n2;
    }

    int getCellY(int n) {
        if ((n -= this.yInset) < 0) {
            return 0;
        }
        int n2 = n / this.cellHeight;
        if (n2 >= this.yExtent) {
            n2 = this.yExtent - 1;
        }
        return n2;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.vec == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        int n = this.getCellX(rectangle.x);
        int n2 = this.getCellY(rectangle.y);
        int n3 = this.getCellX(rectangle.x + rectangle.width + this.cellWidth - 1) + 1;
        int n4 = this.getCellY(rectangle.y + rectangle.height + this.cellHeight - 1) + 1;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > this.xExtent) {
            n3 = this.xExtent;
        }
        if (n4 > this.yExtent) {
            n4 = this.yExtent;
        }
        for (int i = n; i < n3; i += this.xStep) {
            for (int j = n2; j < n4; j += this.yStep) {
                Color color = this.getCellColor(i, j);
                graphics.setColor(color);
                graphics.fillRect(i * this.cellWidth + this.xInset, j * this.cellHeight + this.yInset, this.cellWidth, this.cellHeight);
                graphics.setColor(Color.white);
                if (this.cellWidth > 2) {
                    graphics.drawLine(i * this.cellWidth + this.xInset, j * this.cellHeight + this.yInset, (i + 1) * this.cellWidth - 1 + this.xInset, j * this.cellHeight + this.yInset);
                }
                if (this.cellHeight <= 2) continue;
                graphics.drawLine(i * this.cellWidth + this.xInset, j * this.cellHeight + this.yInset, i * this.cellWidth + this.xInset, (j + 1) * this.cellHeight - 1 + this.yInset);
            }
        }
    }

    int getCellIndex(int n, int n2) {
        return this.yIndex[n2] << (this.n >>> 1) | this.xIndex[n];
    }

    Color getCellColor(int n, int n2) {
        if (n2 * this.xExtent + n > this.vec.length) {
            return null;
        }
        int n3 = this.getCellIndex(n, n2);
        int n4 = this.vec[n3];
        float f = Math.abs((float)n4 / (float)this.maxVal);
        if (f > 1.0f) {
            return Color.green;
        }
        if (f == 0.0f) {
            if (this.selectionModel != null && this.selectionModel.isSelected(n3)) {
                return Color.white;
            }
            return Color.black;
        }
        float f2 = n4 > 0 ? 0.05f : 0.6f;
        Color color = Color.getHSBColor(f2, (float)((double)f * 0.6 + 0.4), (float)((double)f * 0.6 + 0.4));
        if (this.selectionModel != null && this.selectionModel.isSelected(n3)) {
            return new Color(~color.getRGB());
        }
        return color;
    }

    public int getCellIndex(MouseEvent mouseEvent) {
        return this.getCellIndex(this.getCellX(mouseEvent.getX()), this.getCellY(mouseEvent.getY()));
    }

    public int getCellValue(int n) {
        if (this.vec != null) {
            return this.vec[n];
        }
        return 0;
    }

    public int[] getDisplayVector() {
        return this.vec;
    }

    public void setDisplayVector(int[] nArray) {
        if (this.vec != nArray) {
            this.vec = nArray;
            if (this.vec != null && 1 << this.n > this.vec.length) {
                this.setDimension(1);
            } else {
                this.vectorChanged();
            }
        }
    }

    public void setSelectionModel(SelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        if (this.scale != n) {
            this.scale = n;
            this.vectorChanged();
        }
    }

    public int getDimension() {
        return this.n;
    }

    public void setDimension(int n) {
        if (this.n != n) {
            this.n = n;
            int n2 = this.n >>> 1;
            this.xIndex = VectorVis.getSortedIndices(n2);
            this.xExtent = 1 << n2;
            if ((this.n & 1) == 1) {
                this.yIndex = VectorVis.getSortedIndices(n2 + 1);
                this.yExtent = 1 << n2 + 1;
            } else {
                this.yIndex = this.xIndex;
                this.yExtent = this.xExtent;
            }
            this.calcCellGeom();
            this.setMinimumSize(new Dimension(this.xExtent, this.yExtent));
            if (this.vec != null && 1 << this.n > this.vec.length) {
                this.setDisplayVector(null);
            } else {
                this.vectorChanged();
            }
        }
    }

    public synchronized void addCellClickEventListener(CellClickEventListener cellClickEventListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(CellClickEventListener.class, cellClickEventListener);
    }

    public synchronized void removeCellClickEventListener(CellClickEventListener cellClickEventListener) {
        this.listenerList.remove(CellClickEventListener.class, cellClickEventListener);
    }

    protected synchronized void fireCellClickEvent(int n) {
        if (this.listenerList == null) {
            return;
        }
        CellClickEvent cellClickEvent = new CellClickEvent(this, n);
        EventListener[] eventListenerArray = this.listenerList.getListeners(CellClickEventListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((CellClickEventListener)eventListenerArray[i]).cellClicked(cellClickEvent);
        }
    }

    public synchronized void addCellChangedEventListener(CellChangedEventListener cellChangedEventListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(CellChangedEventListener.class, cellChangedEventListener);
    }

    public synchronized void removeCellChangedEventListener(CellChangedEventListener cellChangedEventListener) {
        this.listenerList.remove(CellChangedEventListener.class, cellChangedEventListener);
    }

    protected synchronized void fireCellChangedEvent(int n, int n2) {
        if (this.listenerList == null) {
            return;
        }
        CellChangedEvent cellChangedEvent = new CellChangedEvent(this, n, n2);
        EventListener[] eventListenerArray = this.listenerList.getListeners(CellChangedEventListener.class);
        for (int i = 0; i < eventListenerArray.length; ++i) {
            ((CellChangedEventListener)eventListenerArray[i]).cellChanged(cellChangedEvent);
        }
    }

    class MouseClickListener
    extends MouseAdapter {
        MouseClickListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            VectorVis.this.fireCellClickEvent(VectorVis.this.getCellIndex(mouseEvent));
        }
    }

    class MouseMotionListener
    extends MouseMotionAdapter {
        MouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = VectorVis.this.getCellIndex(mouseEvent);
            if (n != VectorVis.this.lastMouseIndex) {
                VectorVis.this.fireCellChangedEvent(VectorVis.this.lastMouseIndex, n);
                VectorVis.this.lastMouseIndex = n;
            }
        }
    }

    class ResizeListener
    extends ComponentAdapter {
        ResizeListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            VectorVis.this.calcCellGeom();
        }
    }

    public static interface SelectionModel {
        public boolean isSelected(int var1);
    }
}

